import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/route/route.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_icon.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/data/controller/auto_payment/auto_payment_controller.dart';
import 'package:viserpay/view/components/bottom-sheet/bottom_sheet_bar.dart';
import 'package:viserpay/view/components/bottom-sheet/bottom_sheet_close_button.dart';
import 'package:viserpay/view/components/divider/custom_divider.dart';
import 'package:viserpay/view/components/image/custom_svg_picture.dart';
import 'package:viserpay/view/components/text/bottom_sheet_header_text.dart';

class SelectAutoBillPayCategoryBottomSheet extends StatelessWidget {
  const SelectAutoBillPayCategoryBottomSheet({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AutoPaymentController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const BottomSheetBar(),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [BottomSheetHeaderText(text: MyStrings.enableNewAutoPay.tr), const BottomSheetCloseButton()],
          ),
          const CustomDivider(space: Dimensions.space15),
          ListTile(
            leading: const CustomSvgPicture(image: MyIcon.sendMoney, color: MyColor.sendMoneyBaseColor, height: 24, width: 24),
            title: Text(
              MyStrings.sendMoney.tr,
              style: regularDefault.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.8)),
            ),
            trailing: Icon(
              Icons.arrow_forward_ios_rounded,
              color: MyColor.getIconColor(),
            ),
            onTap: () {
              Get.back();
              Get.toNamed(RouteHelper.sendMoneyAutoPaymentScreen);
            },
          ),
          CustomDivider(
            space: 2,
          ),
          ListTile(
            leading: const CustomSvgPicture(image: MyIcon.mobileRecharge, color: MyColor.rechargeBaseColor, height: 24, width: 24),
            title: Text(
              MyStrings.mobileRecharge.tr,
              style: regularDefault.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.8)),
            ),
            trailing: Icon(
              Icons.arrow_forward_ios_rounded,
              color: MyColor.getIconColor(),
            ),
            onTap: () {
              Get.back();
              Get.toNamed(RouteHelper.rechargeAutoPaymentScreen);
            },
          ),
          CustomDivider(
            space: 2,
          ),
          ListTile(
            leading: const CustomSvgPicture(image: MyIcon.paybill, color: MyColor.paybillBaseColor, height: 24, width: 24),
            title: Text(
              MyStrings.paybill.tr,
              style: regularDefault.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.8)),
            ),
            trailing: Icon(
              Icons.arrow_forward_ios_rounded,
              color: MyColor.getIconColor(),
            ),
            onTap: () {
              Get.back();
              Get.toNamed(RouteHelper.payBillAutoPaymentHomeScreen);
            },
          )
        ],
      ),
    );
  }
}
